/****** Object:  StoredProcedure [dbo].[P_EST_FECHA_PROC_MOV_PENDENTE]    Script Date: 11/18/2013 16:19:29 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_FECHA_PROC_MOV_PENDENTE]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_EST_FECHA_PROC_MOV_PENDENTE]
GO

/****** Object:  StoredProcedure [dbo].[P_EST_FECHA_PROC_MOV_PENDENTE]    Script Date: 11/18/2013 16:19:29 ******/
SET ANSI_NULLS ON
GO 
SET QUOTED_IDENTIFIER ON
GO
--  P_EST_FECHA_PROC_MOV_PENDENTE 1,914
CREATE PROCEDURE [dbo].[P_EST_FECHA_PROC_MOV_PENDENTE] (@CD_EMP INT=1,
														@CD_FILIAL_INI AS INT=0, 
														@CD_FILIAL_FINAL INT=0,
														@Debug	tinyint=0) AS
	

SET NOCOUNT ON;
if @Debug=1
begin
	PRINT	'****** Inicio - P_EST_FECHA_PROC_MOV_PENDENTE ******' + CONVERT(VARCHAR(8), GETDATE(), 108);
end

/***********************************************************************************************************/
--Remove filiais inativas da pendencia de processamento.

	DELETE FROM b
	FROM PRC_FILIAL A
		 INNER JOIN EST_PROD_CPL_CUSTO_MEDIO_PROCESSAMENTO_PENDENTE B ON A.CD_EMP = B.CD_EMP
																		 AND A.CD_FILIAL = B.CD_FILIAL
	WHERE
		  A.CD_EMP = 1
		  AND A.STS_FILIAL = 1;

/***********************************************************************************************************/

DECLARE @CD_FILIAL INT

BEGIN TRY
	DECLARE cFilialCustoMedioProc CURSOR FAST_FORWARD READ_ONLY FOR 
	SELECT  DISTINCT 
	 	A.CD_FILIAL
	FROM 
		PRC_FILIAL A
		INNER JOIN  EST_PROD_CPL_CUSTO_MEDIO_PROCESSAMENTO_PENDENTE B ON 
		A.CD_EMP = B.CD_EMP AND
		A.CD_FILIAL = B.CD_FILIAL
	WHERE 
		A.CD_EMP = @CD_EMP  
		AND A.CD_FILIAL BETWEEN CASE WHEN @CD_FILIAL_INI = 0 THEN A.CD_FILIAL 
						ELSE @CD_FILIAL_INI END 
		AND CASE WHEN @CD_FILIAL_FINAL = 0 THEN  
					CASE WHEN @CD_FILIAL_INI = 0 THEN A.CD_FILIAL 
					ELSE  @CD_FILIAL_INI 
					END 			
			ELSE @CD_FILIAL_FINAL 
			END
		AND A.STS_FILIAL=0
	ORDER BY A.CD_FILIAL;
	
	OPEN cFilialCustoMedioProc
	FETCH NEXT FROM cFilialCustoMedioProc INTO @CD_FILIAL

	WHILE @@FETCH_STATUS=0
	BEGIN
		if @debug=1
		begin
			PRINT 'Filial processamento pendente ' + CONVERT(VARCHAR, @CD_FILIAL) + ' ' + CONVERT(VARCHAR, GETDATE (),108)
		end

		EXEC dbo.P_EST_FECHA_PROC_MOV_FILIAL_PENDENTE @CD_EMP, @CD_FILIAL, 0,@Debug;

		EXEC sp_recompile 'P_EST_FECHA_PROC_MOV';

		FETCH NEXT FROM  cFilialCustoMedioProc INTO @CD_FILIAL 
	END
CLOSE cFilialCustoMedioProc
DEALLOCATE cFilialCustoMedioProc
END TRY
    BEGIN CATCH

	   DECLARE @ErrorMessage VARCHAR(4000) = ERROR_MESSAGE();
	   DECLARE @ErrorSeverity INT = ERROR_SEVERITY();
	   DECLARE @ErrorState INT = ERROR_STATE();

	   INSERT INTO ADM_ERRO ( numero ,severidade ,estado ,rotina ,linha ,mensagem ,dtErro )
		  SELECT
			 ERROR_NUMBER()	  AS numero
			 ,@ErrorSeverity	  AS severidade
			 ,@ErrorState		  AS estado
			 ,ERROR_PROCEDURE()	  AS rotina
			 ,ERROR_LINE()		  AS linha
			 ,@ErrorMessage	  AS mensagem
			 ,GETDATE()		  AS dtErro ;

	   RAISERROR(@ErrorMessage, @ErrorSeverity, @ErrorState);

    END CATCH;

if @Debug=1
begin
	PRINT	'****** Fim - P_EST_FECHA_PROC_MOV_PENDENTE ******' + CONVERT(VARCHAR(8), GETDATE(), 108);
end
